import * as z from "zod";
import { UserRoleEnum } from "../enums/role";

export const ownerRoleSchema = z.object({
  role: z.literal(UserRoleEnum.OWNER),
  name: z.string().min(3, "Name must be at least 3 characters"),
});

export const memberRoleSchema = z.object({
  role: z.literal(UserRoleEnum.MEMBER),
  name: z.string().min(3, "Name must be at least 3 characters"),
});

export type OwnerRoleInput = z.infer<typeof ownerRoleSchema>;
export type MemberRoleInput = z.infer<typeof memberRoleSchema>;
