import { QueryConfig } from "@/lib/react-query";
import { User } from "@/lib/types/user";
import { createClient } from "@/utils/supabase/client";
import { queryOptions, useQuery } from "@tanstack/react-query";

export const getSingleUser = async (userId: string): Promise<User> => {
  const supabase = createClient();
  const { data, error } = await supabase
    .from("user")
    .select("*")
    .eq("id", userId)
    .single<User>();

  if (error) {
    throw new Error(error.message);
  }

  return data as User;
};

export const getSingleUserQueryOptions = (userId: string) => {
  return queryOptions({
    queryKey: ["single-user", userId],
    queryFn: () => getSingleUser(userId),
  });
};

type UseGetSingleUserOptions = {
  userId: string;
  queryConfig?: QueryConfig<typeof getSingleUser>;
};

export const useSingleUser = ({
  userId,
  queryConfig,
}: UseGetSingleUserOptions) => {
  return useQuery({
    ...getSingleUserQueryOptions(userId),
    ...queryConfig,
  });
};
