import { MutationConfig } from "@/lib/react-query";
import { Task, TaskDto } from "@/lib/types/task";
import { TaskInput } from "@/lib/validations/task";
import { createClient } from "@/utils/supabase/client";
import { useMutation } from "@tanstack/react-query";

export const insertTask = async ({
  data,
}: {
  data: TaskInput;
}): Promise<TaskDto> => {
  const supabase = createClient();
  const userId = data.user?.id;
  if (!userId) {
    throw new Error("Assignee is required");
  }
  const task: TaskDto = {
    id: data.id,
    title: data.title,
    status: data.status,
    priority: data.priority,
    due_date: data.due_date,
    created_at: new Date(),
    assignee_id: userId,
  };
  const { error } = await supabase.from("task").insert(task);
  if (error) {
    throw new Error(error.message);
  }
  return task;
};

type UseInsertTaskOptions = {
  mutationConfig?: MutationConfig<typeof insertTask>;
};

export const useInsertTask = ({ mutationConfig }: UseInsertTaskOptions) => {
  const { onSuccess, onError, ...restConfig } = mutationConfig || {};

  return useMutation({
    onSuccess: (...args) => {
      onSuccess?.(...args);
    },
    onError: (...args) => {
      onError?.(...args);
    },
    ...restConfig,
    mutationFn: insertTask,
  });
};
