"use client";

import { Button } from "@/components/ui/button";
import { MemberBoard } from "@/features/member/member-board";
import { useLogout } from "@/lib/auth";
import { useRouter } from "next/navigation";
import { toast } from "sonner";
export default function MemberPage() {
  const router = useRouter();

  const logout = useLogout({
    onSuccess: () => {
      toast.success("Logged out successfully");
      router.replace("/auth/login");
      router.refresh();
    },
    onError: () => {
      toast.error("Logout failed");
    },
  });

  function handleLogout() {
    logout.mutate();
  }

  return (
    <div className="flex flex-col w-full">
      <div className="flex flex-row w-full p-4 items-center gap-2">
        <span className="text-xl font-bold flex-1">My Tasks</span>
        <Button variant={"destructive"} onClick={handleLogout}>
          Logout
        </Button>
      </div>
      <MemberBoard />
    </div>
  );
}
