import { z } from "zod";
import { TaskPriorityEnum, TaskStatusEnum } from "../enums/task";
import { UserRoleEnum } from "../enums/role";

export const taskSchema = z.object({
  id: z.string(),
  title: z.string().min(3, "Title must be at least 3 characters"),
  status: z.nativeEnum(TaskStatusEnum),
  priority: z.nativeEnum(TaskPriorityEnum),
  due_date: z.date().nullable(),
  created_at: z.date(),
  column: z.string(),
  user: z
    .object({
      id: z.string(),
      email: z.string(),
      name: z.string().nullable(),
      role: z.nativeEnum(UserRoleEnum).nullable(),
    })
    .nullable(),
});

export type TaskInput = z.infer<typeof taskSchema>;
