import { TaskPriorityEnum, TaskStatusEnum } from "../enums/task";
import { User } from "./user";

export type Task = {
  id: string;
  created_at: Date;
  title: string;
  status: TaskStatusEnum;
  due_date: Date | null;
  priority: TaskPriorityEnum;
  user: User | null;
};

export type TaskDto = {
  id: string;
  created_at: Date;
  title: string;
  status: string;
  due_date: Date | null;
  priority: string;
  assignee_id: string;
};
