import { Task } from "./task";
import { User } from "./user";
import { TaskPriorityEnum, TaskStatusEnum } from "../enums/task";

export type TOwnerColumnProps = {
  user: User;
  cards: TOwnerCard[];
  className?: string;
};

export type TOwnerCard = {
  id: string;
  created_at: Date;
  title: string;
  due_date: Date | null;
  priority: TaskPriorityEnum;
  status: TaskStatusEnum;
  user: User;
};

export function tasksToTOwnerCards(tasks: Task[]): TOwnerCard[] {
  return tasks.map(
    (task): TOwnerCard => ({
      id: task.id,
      created_at: task.created_at,
      title: task.title,
      due_date: task.due_date,
      priority: task.priority,
      status: task.status,
      user: task.user!,
    })
  );
}

export type TOwnerCardProps = {
  card: TOwnerCard;
};
