export enum TaskStatusEnum {
  PENDING = "Pending",
  IN_PROGRESS = "In Progress",
  COMPLETED = "Completed",
}

export function toTaskStatusEnum(status: string) {
  switch (status) {
    case "Pending":
      return TaskStatusEnum.PENDING;
    case "In Progress":
      return TaskStatusEnum.IN_PROGRESS;
    case "Completed":
      return TaskStatusEnum.COMPLETED;
    default:
      return TaskStatusEnum.PENDING;
  }
}

export enum TaskPriorityEnum {
  NONE = "None",
  LOW = "Low",
  MEDIUM = "Medium",
  HIGH = "High",
}

export function toTaskPriorityEnum(priority: string) {
  switch (priority) {
    case "None":
      return TaskPriorityEnum.NONE;
    case "Low":
      return TaskPriorityEnum.LOW;
    case "Medium":
      return TaskPriorityEnum.MEDIUM;
    case "High":
      return TaskPriorityEnum.HIGH;
    default:
      return TaskPriorityEnum.NONE;
  }
}
