import { UserRoleEnum } from "@/lib/enums/role";
import { MutationConfig } from "@/lib/react-query";
import { UpdateUserInput } from "@/lib/validations/user";
import { createClient } from "@/utils/supabase/client";
import { supabaseConfig } from "@/utils/supabase/config";
import { useMutation } from "@tanstack/react-query";
import { getMembers } from "./get-members";

export const updateUser = async ({
  data,
}: {
  data: UpdateUserInput;
}): Promise<void> => {
  if (!data.id) {
    throw new Error("User id is required");
  }
  const supabase = createClient();
  let position = null;
  if (data.role == UserRoleEnum.MEMBER) {
    const members = await getMembers();
    position = members.length + 1;
  }
  const { error } = await supabase
    .from(supabaseConfig.column.user)
    .update({
      id: data.id,
      email: data.email,
      name: data.name,
      role: data.role,
      position: position,
    })
    .eq("id", data.id);
  if (error) {
    throw new Error(error.message);
  }
};

type UseUpdateUserOptions = {
  mutationConfig?: MutationConfig<typeof updateUser>;
};

export const useUpdateUser = ({ mutationConfig }: UseUpdateUserOptions) => {
  const { onSuccess, onError, ...restConfig } = mutationConfig || {};

  return useMutation({
    onSuccess: (...args) => {
      onSuccess?.(...args);
    },
    onError: (...args) => {
      onError?.(...args);
    },
    ...restConfig,
    mutationFn: updateUser,
  });
};
