import { MutationConfig } from "@/lib/react-query";
import { Task, TaskDto } from "@/lib/types/task";
import { TaskInput } from "@/lib/validations/task";
import { createClient } from "@/utils/supabase/client";
import { supabaseConfig } from "@/utils/supabase/config";
import { useMutation } from "@tanstack/react-query";

export const updateTask = async ({
  data,
}: {
  data: TaskInput;
}): Promise<void> => {
  const supabase = createClient();

  const { error } = await supabase
    .from(supabaseConfig.column.task)
    .update({
      id: data.id,
      title: data.title,
      status: data.status,
      priority: data.priority,
      due_date: data.due_date,
      created_at: data.created_at,
      assignee_id: data.user?.id,
    })
    .eq("id", data.id);

  if (error) {
    throw new Error(error.message);
  }
};

type UseUpdateTaskOptions = {
  mutationConfig?: MutationConfig<typeof updateTask>;
};

export const useUpdateTask = ({
  mutationConfig,
}: UseUpdateTaskOptions = {}) => {
  const { onSuccess, onError, ...restConfig } = mutationConfig || {};

  return useMutation({
    onSuccess: (...args) => {
      onSuccess?.(...args);
    },
    onError: (...args) => {
      onError?.(...args);
    },
    ...restConfig,
    mutationFn: updateTask,
  });
};
