import { MutationConfig } from "@/lib/react-query";
import { Task, TaskDto } from "@/lib/types/task";
import { TaskInput } from "@/lib/validations/task";
import { createClient } from "@/utils/supabase/client";
import { supabaseConfig } from "@/utils/supabase/config";
import { useMutation } from "@tanstack/react-query";

export const deleteTask = async ({
  taskId,
}: {
  taskId: string;
}): Promise<void> => {
  const supabase = createClient();
  const { error } = await supabase
    .from(supabaseConfig.column.task)
    .delete()
    .eq("id", taskId);

  if (error) {
    throw new Error(error.message);
  }
};

type UseDeleteTaskOptions = {
  mutationConfig?: MutationConfig<typeof deleteTask>;
};

export const useDeleteTask = ({
  mutationConfig,
}: UseDeleteTaskOptions = {}) => {
  const { onSuccess, onError, ...restConfig } = mutationConfig || {};

  return useMutation({
    onSuccess: (...args) => {
      onSuccess?.(...args);
    },
    onError: (...args) => {
      onError?.(...args);
    },
    ...restConfig,
    mutationFn: deleteTask,
  });
};
