"use client";

import { useGetAllTask } from "@/features/task/supabase/get-task";
import OwnerBoardColumn from "./owner-board-column";
import { tasksToTOwnerCards } from "@/lib/types/owner-kanban";

export const OwnerBoard = () => {
  const tasks = useGetAllTask();

  return (
    <div className="flex flex-col h-full w-full p-4 lg:flex-row lg:gap-3 lg:overflow-auto lg:p-12">
      {Array.from(tasks.data?.entries() ?? []).map(
        ([userId, { user, tasks }]) => (
          <OwnerBoardColumn
            key={userId}
            className="w-72"
            user={user}
            cards={tasksToTOwnerCards(tasks)}
          />
        )
      )}
    </div>
  );
};
