import { motion } from "framer-motion";
import { useEffect, useRef, useState } from "react";
import { BiDotsVerticalRounded } from "react-icons/bi";
import { DropIndicator } from "../member/kanban/DropIndicator";
import { User } from "@/lib/types/user";
import { MemberDropIndicator } from "./member-drop-indicator";

interface MemberCardProps {
  card: User;
  handleDragStart: (event: any, card: User) => void;
  setCards: (cards: User[]) => void;
}

export const MemberCard = ({
  card,
  handleDragStart: handleDragStart,
}: MemberCardProps) => {
  const { id, name, position } = card;
  const cardRef = useRef<HTMLDivElement>(null);
  return (
    <>
      <MemberDropIndicator beforeId={id} />
      <motion.div
        layout
        layoutId={id}
        draggable
        ref={cardRef}
        onDragStart={(event) => handleDragStart(event, card)}
        className="cursor-grab rounded  border border-neutral-700 bg-neutral-800 p-5 lg:p-3 active:cursor-grabbing relative"
      >
        <p className="text-sm text-neutral-100 break-words">{position}{". "}{name}</p>
      </motion.div>
    </>
  );
};
