"use client";

import { motion } from "framer-motion";
import { FiPlus } from "react-icons/fi";
import { FormEvent, useState } from "react";
import { TAddCardProps, TCard } from "@/lib/types/kanban";
import { TaskPriorityEnum } from "@/lib/enums/task";

export const AddCard = ({ column, insertCard }: TAddCardProps) => {
  const [title, setTitle] = useState("");
  const [adding, setAdding] = useState(false);
  const handleSubmit = (event: FormEvent) => {
    event.preventDefault();
    if (!title.trim().length) return;
    const card: TCard = {
      id: crypto.randomUUID(),
      created_at: new Date(),
      title: title.trim(),
      due_date: null,
      priority: TaskPriorityEnum.NONE,
      user: null,
      column,
    };
    insertCard(card);
    setAdding(false);
  };
  return (
    <>
      {adding ? (
        <motion.form layout onSubmit={handleSubmit}>
          <textarea
            onChange={(event) => setTitle(event.target.value)}
            autoFocus
            placeholder="Add new task..."
            className="w-full rounded border border-neutral-400 bg-neutral-400/20 p-3 text-sm text-neutral-950 placeholder-neutral-600 focus:outline-none"
          />
          <div className="flex items-center justify-end mt-1.5 gap-1.5 text-xs">
            <button
              onClick={() => setAdding(false)}
              className="px-3 py-1.5  text-neutral-400 transition-colors hover:text-red-500"
            >
              Close
            </button>
            <button
              type="submit"
              className="px-3 py-1.5 flex items-center gap-1.5 rounded bg-neutral-50 text-neutral-950 transition-colors hover:bg-neutral-300"
            >
              <span>Add</span>
              <FiPlus />
            </button>
          </div>
        </motion.form>
      ) : (
        <motion.button
          layout
          onClick={() => setAdding(true)}
          className="flex w-full items-center gap-1.5 px-3 py-1.5 text-xs text-neutral-400 transition-colors hover:text-black outline-none"
        >
          <span>Add card</span>
          <FiPlus />
        </motion.button>
      )}
    </>
  );
};
