"use client";

import { QueryClient, QueryClientProvider } from "@tanstack/react-query";
import { ReactQueryDevtools } from "@tanstack/react-query-devtools";
import * as React from "react";
import { ErrorBoundary } from "react-error-boundary";

import { Toaster } from "sonner";
import { MainErrorFallback } from "@/components/errors/main";
import { queryConfig } from "@/lib/react-query";

type AppProviderProps = {
  children: React.ReactNode;
};

export const AppProvider = ({ children }: AppProviderProps) => {
  const [queryClient] = React.useState(
    () =>
      new QueryClient({
        defaultOptions: queryConfig,
      })
  );

  return (
    <QueryClientProvider client={queryClient}>
      <main className="w-full">
        <ErrorBoundary FallbackComponent={MainErrorFallback}>
          {process.env.DEV && <ReactQueryDevtools />}
          <Toaster />
          {children}
        </ErrorBoundary>
      </main>
    </QueryClientProvider>
  );
};
